<?php $__env->startSection('panel'); ?>
<div class="row mb-none-30">
  <div class="col-md-12">
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive--sm">
                <table class="table table--light style--two">
                    <thead>
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Price'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Limit/Day'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Validity'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Referral Commission'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($plan->name); ?></td>
                            <td data-label="<?php echo app('translator')->get('Price'); ?>" class="font-weight-bold"><?php echo e(showAmount($plan->price)); ?> <?php echo e($general->cur_text); ?></td>

                            <td data-label="<?php echo app('translator')->get('Limit/Day'); ?>"><?php echo e($plan->daily_limit); ?> <?php echo app('translator')->get('PTC'); ?></td>
                            <td data-label="<?php echo app('translator')->get('Validity'); ?>"><?php echo e($plan->validity); ?> <?php echo app('translator')->get('Day'); ?></td>
                            <td data-label="<?php echo app('translator')->get('Referral Commission'); ?>"><?php echo app('translator')->get('up to'); ?> <span class="font-weight-bold text-primary px-3"><?php echo e($plan->ref_level); ?> </span><?php echo app('translator')->get('level'); ?></td>
                            <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                <?php if($plan->status == 1): ?>
                                    <span class="badge badge--success"><?php echo app('translator')->get('Active'); ?></span>
                                    <?php else: ?>
                                    <span class="badge badge--danger">
                                        <?php echo app('translator')->get('Inactive'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                <button class="btn btn-outline--primary btn-sm planBtn" data-id="<?php echo e($plan->id); ?>" data-name="<?php echo e($plan->name); ?>" data-price="<?php echo e(getAmount($plan->price)); ?>" data-daily_limit="<?php echo e($plan->daily_limit); ?>" data-validity="<?php echo e($plan->validity); ?>" data-status="<?php echo e($plan->status); ?>" data-ref_level="<?php echo e($plan->ref_level); ?>" data-act="Edit">
                                    <i class="la la-pencil"></i> <?php echo app('translator')->get('Edit'); ?>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
  </div>
</div>

<div class="modal fade" id="planModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title"><span class="act"></span> <?php echo app('translator')->get('Subscription Plan'); ?></h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <i class="las la-times"></i>
            </button>
            </div>
            <form action="<?php echo e(route('admin.plan.save')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name"><?php echo app('translator')->get('Name'); ?> </label>
                        <input type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('Plan Name'); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="price"><?php echo app('translator')->get('Price'); ?> </label>
                        <div class="input-group">
                            <input type="text" class="form-control has-append" name="price" placeholder="<?php echo app('translator')->get('Price of Plan'); ?>" required>
                            <div class="input-group-text"><?php echo e($general->cur_text); ?></div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="daily_limit"><?php echo app('translator')->get('Daily Ad Limit'); ?></label>
                        <input type="number" class="form-control" name="daily_limit" placeholder="<?php echo app('translator')->get('Daily Ad Limit'); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="daily_limit"><?php echo app('translator')->get('Validity'); ?></label>
                        <div class="input-group">
                            <input type="number" class="form-control" name="validity" placeholder="<?php echo app('translator')->get('Validity'); ?>" required>
                            <div class="input-group-text"><?php echo app('translator')->get('Days'); ?></div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="details"><?php echo app('translator')->get('Referral Commission'); ?> </label>
                        <select name="ref_level" class="form-control" required>
                            <option value="0"> <?php echo app('translator')->get('NO Referral Commission'); ?></option>
                            <?php for($i = 1; $i <= $levels; $i++): ?>
                            <option value="<?php echo e($i); ?>"> <?php echo app('translator')->get('Up to'); ?> <?php echo e($i); ?>  <?php echo app('translator')->get('Level'); ?></option>
                            <?php endfor; ?>
                        </select>

                    </div>
                    <div class="form-group">
                        <label for="status"><?php echo app('translator')->get('Status'); ?></label>
                        <input type="checkbox" data-width="100%" data-height="50" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Enable'); ?>" data-off="<?php echo app('translator')->get('Disable'); ?>" name="status">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary w-100"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary btn-sm planBtn" data-id="0" data-act="Add" data-bs-toggle="modal" data-bs-target="#planModal"><i class="las la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
<script>
    (function($){
        "use strict";
        $('.planBtn').on('click', function() {
            var modal = $('#planModal');
            modal.find('.act').text($(this).data('act'));
            modal.find('input[name=id]').val($(this).data('id'));
            modal.find('input[name=name]').val($(this).data('name'));
            modal.find('input[name=price]').val($(this).data('price'));
            modal.find('input[name=daily_limit]').val($(this).data('daily_limit'));
            modal.find('input[name=validity]').val($(this).data('validity'));
            modal.find('input[name=status]').bootstrapToggle($(this).data('status') == 1 ? 'on' : 'off');
            modal.find('select[name=ref_level]').val($(this).data('ref_level'));
            if($(this).data('id') == 0){
                modal.find('form')[0].reset();
            }
            modal.modal('show');
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sites/26a/6/600a7d1250/sub/solargreen/core/resources/views/admin/plan.blade.php ENDPATH**/ ?>