<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form role="form" method="POST" action="<?php echo e(route("admin.ptc.store")); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                       <div class="form-group col-md-8">
                            <label><?php echo app('translator')->get('Title of the Ad'); ?></label>
                            <input type="text" name="title" class="form-control" value="<?php echo e(old('title')); ?>" placeholder="<?php echo app('translator')->get('Title'); ?>" required>
                        </div>

                        <div class="form-group col-md-4">
                            <label><?php echo app('translator')->get('Amount'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" name="amount" class="form-control" value="<?php echo e(old('amount')); ?>" placeholder="<?php echo app('translator')->get('User will get ...'); ?>" required>
                                <div class="input-group-text"> <?php echo e($general->cur_text); ?> </div>
                            </div>
                        </div>


                        <div class="form-group col-md-4">
                            <label><?php echo app('translator')->get('Duration'); ?></label>
                            <div class="input-group">
                                <input type="number" name="duration" class="form-control" value="<?php echo e(old('duration')); ?>" placeholder="<?php echo app('translator')->get('Duration'); ?>" required>
                                <div class="input-group-text"><?php echo app('translator')->get('SECONDS'); ?></div>
                            </div>
                        </div>

                        <div class="form-group col-md-4">
                            <label><?php echo app('translator')->get('Maximum Show'); ?></label>
                            <div class="input-group">
                                <input type="number" name="max_show" class="form-control" value="<?php echo e(old('max_show')); ?>" placeholder="<?php echo app('translator')->get('Maximum Show'); ?> " required>
                                <div class="input-group-text"><?php echo app('translator')->get('Times'); ?></div>
                            </div>
                        </div>

                        <div class="form-group col-md-4">
                            <label><?php echo app('translator')->get('Status'); ?></label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-on="Active" data-off="Inactive" name="status">
                        </div>
                    </div>

                    <div class="row pt-5 mt-5 border-top">
                        <div class="form-group col-md-4">
                            <label for="ads_type"><?php echo app('translator')->get('Advertisement Type'); ?></label>
                            <select class="form-control" id="ads_type" name="ads_type" required>
                                <option value="1" <?php echo e(old('ads_type')==1?'selected':''); ?>><?php echo app('translator')->get('Link / URL'); ?></option>
                                <option value="2" <?php echo e(old('ads_type')==2?'selected':''); ?>><?php echo app('translator')->get('Banner / Image'); ?></option>
                                <option value="3" <?php echo e(old('ads_type')==3?'selected':''); ?>><?php echo app('translator')->get('Script / Code'); ?></option>
                                <option value="4" <?php echo e(old('ads_type')==4?'selected':''); ?>><?php echo app('translator')->get('Youtube Embeded Link'); ?></option>
                            </select>
                        </div>
                        <div class="form-group col-md-8" id="websiteLink">
                            <label><?php echo app('translator')->get('Link'); ?></label>
                            <input type="text" name="website_link" class="form-control" value="<?php echo e(old('website_link')); ?>" placeholder="<?php echo app('translator')->get('http://example.com'); ?>">
                        </div>
                        <div class="form-group col-md-8" id="youtube">
                            <label><?php echo app('translator')->get('Youtube Embeded Link'); ?></label>
                            <input type="text" name="youtube" class="form-control" value="<?php echo e(old('youtube')); ?>" placeholder="<?php echo app('translator')->get('https://www.youtube.com/embed/your_code'); ?>">
                        </div>
                        <div class="form-group col-md-8 d-none" id="bannerImage">
                            <label><?php echo app('translator')->get('Banner'); ?></label>
                            <input type="file" class="form-control"  name="banner_image">
                        </div>
                        <div class="form-group col-md-8 d-none" id="script">
                            <label><?php echo app('translator')->get('Script'); ?></label>
                            <textarea  name="script" class="form-control"><?php echo e(old('script')); ?></textarea>
                        </div>
                    </div>
                    <div class="form-group col-md-12 mt-3">
                        <button type="submit" class="btn btn--primary h-45 w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.ptc.index')); ?>" class="btn btn-outline--primary btn-sm"><i class="las la-undo"></i> <?php echo app('translator')->get('Back'); ?> </a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
<script>
    (function($){
        "use strict";
        $('#ads_type').change(function(){
            var adType = $(this).val();
            if (adType == 1) {
                $("#websiteLink").removeClass('d-none');
                $("#bannerImage").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").addClass('d-none');
            } else if (adType == 2) {
                $("#bannerImage").removeClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").addClass('d-none');
            } else if(adType == 3) {
                $("#bannerImage").addClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").removeClass('d-none');
                $("#youtube").addClass('d-none');
            } else {
                $("#bannerImage").addClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").removeClass('d-none');
            }
        }).change();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\core\resources\views/admin/ptc/create.blade.php ENDPATH**/ ?>